Imports EposCmd.Net
Imports EposCmd.Net.DeviceCmdSet.Operation

Public Class Form1

    Dim connector As DeviceManager
    Dim epos As Device

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal ea As System.EventArgs) Handles ButtonDeviceSettings.Click

        Try
            connector = New DeviceManager

            'Dim b As Integer

            'b = connector.Baudrate

            'connector.Baudrate = b
            'connector.Timeout = 500

            ButtonEnable.Enabled = True

        Catch e As EposCmd.Net.DeviceException
            StopRefresh()
            ShowMessageBox(e.ErrorMessage, e.ErrorCode)
        Catch e As Exception
            StopRefresh()
            MessageBox.Show(e.Message)
        End Try

    End Sub

    Private Sub ButtonEnable_Click(ByVal sender As System.Object, ByVal ea As System.EventArgs) Handles ButtonEnable.Click
        Try
            epos = connector.CreateDevice(TextBoxNodeId.Text)

            TextBoxAOM.Text = epos.Operation.OperationMode.GetOperationModeAsString()

            Dim sm As StateMachine

            sm = epos.Operation.StateMachine

            If sm.GetFaultState() Then
                sm.ClearFault()
            End If

            sm.SetEnableState()

            ButtonDeviceSettings.Enabled = False
            ButtonEnable.Enabled = False
            ButtonDisable.Enabled = True
            ButtonMove.Enabled = True
            ButtonHalt.Enabled = True

            Timer1.Enabled = True

        Catch e As EposCmd.Net.DeviceException
            StopRefresh()
            ShowMessageBox(e.ErrorMessage, e.ErrorCode)
        Catch e As Exception
            StopRefresh()
            MessageBox.Show(e.Message)
        End Try
    End Sub

    Private Sub ButtonDisable_Click(ByVal sender As System.Object, ByVal ea As System.EventArgs) Handles ButtonDisable.Click
        Try
            Dim sm As StateMachine

            sm = epos.Operation.StateMachine

            If sm.GetFaultState() Then
                sm.ClearFault()
            End If

            If sm.GetDisableState() = False Then
                sm.SetDisableState()
            End If

            ButtonDeviceSettings.Enabled = True
            ButtonEnable.Enabled = True
            ButtonDisable.Enabled = False
            ButtonMove.Enabled = False
            ButtonHalt.Enabled = False
        Catch e As EposCmd.Net.DeviceException
            StopRefresh()
            ShowMessageBox(e.ErrorMessage, e.ErrorCode)
        Catch e As Exception
            StopRefresh()
            MessageBox.Show(e.Message)
        End Try
    End Sub

    Private Sub ButtonExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonExit.Click
        Close()
    End Sub

    Private Sub ButtonMove_Click(ByVal sender As System.Object, ByVal ea As System.EventArgs) Handles ButtonMove.Click

        Try
            Dim ppm As ProfilePositionMode

            ppm = epos.Operation.ProfilePositionMode

            ppm.ActivateProfilePositionMode()

            TextBoxAOM.Text = epos.Operation.OperationMode.GetOperationModeAsString()

            TextBoxPositionStart.Text = String.Format("{0}", epos.Operation.MotionInfo.GetPositionIs())

            Dim tp As Integer
            Dim absolute As Boolean

            tp = Convert.ToInt32(TextBoxTargetPosition.Text)

            absolute = RadioButtonAbsolute.Checked

            ppm.MoveToPosition(tp, absolute, True)
        Catch e As EposCmd.Net.DeviceException
            StopRefresh()
            ShowMessageBox(e.ErrorMessage, e.ErrorCode)
        Catch e As OverflowException
            MessageBox.Show(e.Message)
        Catch e As FormatException
            MessageBox.Show(e.Message)
        Catch e As Exception
            StopRefresh()
            MessageBox.Show(e.Message)
        End Try
    End Sub

    Private Sub ButtonHalt_Click(ByVal sender As System.Object, ByVal ea As System.EventArgs) Handles ButtonHalt.Click

        Try
            Dim ppm As ProfilePositionMode

            ppm = epos.Operation.ProfilePositionMode

            ppm.ActivateProfilePositionMode()

            TextBoxAOM.Text = epos.Operation.OperationMode.GetOperationModeAsString()

            ppm.HaltPositionMovement()
        Catch e As EposCmd.Net.DeviceException
            StopRefresh()
            ShowMessageBox(e.ErrorMessage, e.ErrorCode)
        Catch e As Exception
            StopRefresh()
            MessageBox.Show(e.Message)
        End Try
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If epos Is Nothing Then
            ' object doesn't exist yet
        Else
            Try
                TextBoxActualPosition.Text = String.Format("{0}", epos.Operation.MotionInfo.GetPositionIs())
            Catch ex As EposCmd.Net.DeviceException
                StopRefresh()
                ShowMessageBox(ex.ErrorMessage, ex.ErrorCode)
            Catch ex As Exception
                StopRefresh()
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    Private Sub StopRefresh()
        Timer1.Enabled = False

        If epos Is Nothing Then
            ' object doesn't exist yet
        Else
            ButtonDeviceSettings.Enabled = true
            ButtonEnable.Enabled = false
            ButtonDisable.Enabled = false
            ButtonMove.Enabled = false
            ButtonHalt.Enabled = false

            epos = Nothing
        End If

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Timer1.Interval = 500
        Timer1.Enabled = False
    End Sub

    Private Sub ShowMessageBox(ByVal text As String, ByVal errorCode As UInteger)

        Dim errorMsg As String

        errorMsg = String.Format("ErrorCode: {1:X8}", text, errorCode)

        MessageBox.Show(text + Environment.NewLine + errorMsg, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)

    End Sub

    Private Sub Form1_FormClosing(sender As Object, e As FormClosingEventArgs) Handles MyBase.FormClosing
        StopRefresh()

        If Not connector Is Nothing Then
            connector.Dispose()
        End If
    End Sub
End Class
